import {createAction} from 'redux-actions';
import {saveSearchCalendarVisibility} from '../lib/searchCalendar';

export const SET_SEARCH_CALENDAR_VISIBILITY = Symbol(
    'SET_SEARCH_CALENDAR_VISIBILITY',
);

export const setSearchCalendarVisibility = createAction(
    SET_SEARCH_CALENDAR_VISIBILITY,
);

export const updateSearchCalendarVisibility =
    visibility =>
    ({dispatch, cookies}) => {
        saveSearchCalendarVisibility(cookies, visibility);
        dispatch(setSearchCalendarVisibility(visibility));
    };
