import {getNow} from '../lib/date/utils';

export const SET_NOW = Symbol('SET_NOW');

export const setNow =
    req =>
    ({dispatch}) => {
        let payload = getNow();

        if (req && req.mock) {
            payload = req.mock.getNow();
        } else if (typeof window !== 'undefined' && window.MOCK) {
            payload = window.MOCK.now;
        }

        dispatch({
            type: SET_NOW,
            payload,
        });
    };
