import Dispatch from '../interfaces/actions/Dispatch';
import GetState from '../interfaces/actions/GetState';

import {stationUrl} from '../lib/url/stationUrl';
import setUrl from '../../client/lib/setUrl';

interface ISetStationUrl {
    dispatch: Dispatch;
    getState: GetState;
}

/*
 * Функция сохранения состояния поиска в текущем browserHistory
 * вызывается при изменении фильтров на странице станции
 */
export default function setStationUrl({
    dispatch,
    getState,
}: ISetStationUrl): void {
    const state = getState();
    const {
        tld,
        language,
        isTouch,
        station: {
            id,
            type,
            currentSubtype,
            mainSubtype,
            whenDate,
            whenSpecial,
            event,
            directionCode,
            terminalName,
            time,
            search,
            stop,
        },
    } = state;

    const path = stationUrl({
        id,
        tld,
        language,
        type,
        subtype: currentSubtype,
        mainSubtype,
        isMobile: isTouch,
        date: whenDate,
        special: whenSpecial,
        event,
        direction: directionCode,
        terminalName,
        time,
        search,
        stopId: stop?.id,
    });

    setUrl(dispatch, path);
}
