import {createAction} from 'typesafe-actions';

import IStationFromApi from '../interfaces/state/station/IStationFromApi';
import ICityData from '../interfaces/state/station/ICityData';
import IStationPopularDirectionsFromApi from '../interfaces/state/station/IStationPopularDirectionsFromApi';
import StationTime from '../interfaces/state/station/StationTime';
import ThunkAction from '../interfaces/actions/ThunkAction';
import IStationStop from '../interfaces/state/station/IStationStop';
import IStationStopsFromBackend from '../interfaces/state/station/IStationStopsFromBackend';

import setStationUrl from './setStationUrl';

interface ITeaserIsOpenedAction {
    id: number;
    isOpened: boolean;
}

export const setDataForFetchingPage = createAction(
    '@station/SET_DATA_FOR_FETCHING_PAGE',
)();

export const setDataFromAPI = createAction('@station/SET_DATA_FROM_API')<
    IStationFromApi & IStationStopsFromBackend
>();

export const setStationCityStations = createAction(
    '@station/SET_STATION_CITY_STATIONS',
)<ICityData>();

export const setStationPopularDirections = createAction(
    '@station/SET_STATION_POPULAR_DIRECTIONS',
)<IStationPopularDirectionsFromApi>();

export const setCalendarIsOpened = createAction(
    '@station/SET_CALENDAR_IS_OPENED',
)<boolean>();

export const setMoreDirectionsIsOpened = createAction(
    '@station/SET_MORE_DIRECTIONS_IS_OPENED',
)<boolean>();

export const setTeaserIsOpened = createAction(
    '@station/SET_TEASER_IS_OPENED',
)<ITeaserIsOpenedAction>();

export const setGoneThreadsAreOpened = createAction(
    '@station/SET_GONE_THREADS_ARE_OPENED',
)<boolean>();

export const setSearch = createAction('@station/SET_SEARCH')<string>();

export const setTime = createAction('@station/SET_TIME')<
    StationTime | undefined
>();

export const setTerminalName = createAction(
    '@station/SET_TERMINAL_NAME',
)<string>();

export const setStopText = createAction('@station/SET_STOP_TEXT')<string>();

export const setStop = createAction('@station/SET_STOP')<IStationStop | null>();

export const setStationFilterIsOpened = createAction(
    '@station/SET_STATION_FILTER_IS_OPENED',
)<boolean>();

export const changeFilterSearch =
    (search: string): ThunkAction =>
    ({dispatch, getState}) => {
        dispatch(setSearch(search));
        setStationUrl({dispatch, getState});
    };

export const changeFilterTime =
    (time?: StationTime): ThunkAction =>
    ({dispatch, getState}) => {
        dispatch(setTime(time));
        setStationUrl({dispatch, getState});
    };

export const changeFilterTerminalName =
    (terminalName: string): ThunkAction =>
    ({dispatch, getState}) => {
        dispatch(setTerminalName(terminalName));
        setStationUrl({dispatch, getState});
    };

export const changeFilterStop =
    (stop: IStationStop | null): ThunkAction =>
    ({dispatch, getState}) => {
        dispatch(setStopText(stop?.title || ''));
        dispatch(setStop(stop));
        setStationUrl({dispatch, getState});
    };
