import jsonp from 'jsonp';

import {setUnreadMailCount} from './index';

export default function requestUnreadMailCount() {
    return ({dispatch}) => {
        const url = '//mail.yandex.ru/api/v2/rasp/counters?silent';

        jsonp(url, (error, response) => {
            if (!response || !response.counters || !response.counters.unread) {
                return;
            }

            const count = parseInt(response.counters.unread, 10);

            dispatch(setUnreadMailCount(count));
        });
    };
}
