import React, {memo, useEffect, useRef} from 'react';
import B from 'bem-cn-lite';
import {v4 as uuid} from 'uuid';

import {OWNER_ID, SITE_ID} from '../../lib/constants/adFox';

import AdFoxType from '../../interfaces/components/adFox/AdFoxType';
import AdFoxPosition from '../../interfaces/components/adFox/AdFoxPosition';
import IAdFoxCreateError from '../../interfaces/IAdFoxCreateError';

const b = B('AdFoxBanner');

interface IAdFoxBannerParams {
    position: AdFoxPosition;
    type: AdFoxType;

    onError?: () => void;
    className?: string;
}

export default memo(AdFoxBanner);

function AdFoxBanner({
    position,
    type,

    onError,
    className,
}: IAdFoxBannerParams): React.ReactElement | null {
    const blockRef = useRef<HTMLDivElement | null>(null);

    useEffect(() => {
        const blockElement = blockRef.current;

        if (!blockElement) {
            return;
        }

        // Генерируем id блока и присваиваем его элементу
        const blockId = `adfox-${type}-${position}-${uuid()}`;

        blockElement.id = blockId;

        window.yaContextCb.push(() => {
            if (!window.Ya) {
                return;
            }

            window.Ya.adfoxCode?.create({
                ownerId: OWNER_ID,
                containerId: blockId,
                params: {
                    pp: position,
                    ps: SITE_ID,
                    p2: type,
                },

                onStub() {
                    if (onError) {
                        onError();
                    }
                },
                onError(error: IAdFoxCreateError) {
                    if (error && onError) {
                        onError();
                    }
                },
            });
        });
    }, [onError, position, type]);

    return <div className={b({}, className)} ref={blockRef} />;
}
