import {React, PureComponent, B} from '../base';

const b = B('AmbiguousOption');

export default class AmbiguousOption extends PureComponent {
    onClick = e => {
        const {selected, onClick, group} = this.props;

        if (!selected && onClick) {
            const {name, value, slug} = e.currentTarget.dataset;

            onClick(group, {
                title: name,
                key: value,
                slug,
            });
        }
    };

    render() {
        const {value, key, selectedKey} = this.props;
        const {ambiguousTitle = {}} = value;
        const {title = [value.title], additionalTitle = 'additionalTitle'} =
            ambiguousTitle;

        const selected = title.map(item => item.key).includes(selectedKey);

        return (
            <li className={b()} key={key}>
                <div className={b('additional-title', {selected})}>
                    {additionalTitle}
                </div>

                {title.map((item, linkKey) => (
                    <div key={linkKey}>
                        <span
                            key={linkKey}
                            className={b('link-title', {
                                selected: selectedKey === item.key,
                            })}
                            onClick={this.onClick}
                            data-value={item.key}
                            data-name={item.name}
                            data-slug={item.slug}
                        >
                            {item.name}
                        </span>
                    </div>
                ))}
            </li>
        );
    }
}
