import {React, PureComponent, B} from '../base';

import Platform from '../../interfaces/Platform';

import {connect} from 'react-redux';

import {reachGoal} from '../../lib/yaMetrika';
import {
    setFromPointFromUser,
    setToPointFromUser,
    submitForm,
} from '../../actions/searchForm';

import AmbiguousOption from '../AmbiguousOption/AmbiguousOption';

import keyset from '../../i18n/ambiguous';

const b = B('AmbiguousPage');

const isMobile = process.env.PLATFORM === Platform.mobile;

export const AMBIGUOUS_PAGE_NAME = 'ambiguous';

class AmbiguousPage extends PureComponent {
    componentDidMount() {
        reachGoal('ambiguous_page_show', {
            'ambiguous_page_show-url': window.location.href,
        });
    }

    onVariantClick = (group, value) => {
        const {searchForm, dispatch} = this.props;
        const {from, to, ambiguous} = searchForm;
        const fromIsDefined = from.key || !ambiguous.from;
        const toIsDefined = to.key || !ambiguous.to;
        const isFromGroup = group === 'from';
        const isToGroup = group === 'to';

        dispatch(
            isFromGroup
                ? setFromPointFromUser(value)
                : setToPointFromUser(value),
        );

        if ((fromIsDefined && isToGroup) || (toIsDefined && isFromGroup)) {
            dispatch(submitForm());
        }
    };

    listCreator(group) {
        const {searchForm} = this.props;
        const {ambiguous} = searchForm;

        const groupIsSelected = !ambiguous[group];
        const items =
            (groupIsSelected ? [searchForm[group]] : ambiguous[group]) || [];

        return (
            <ul className={b('variants')}>
                {items.map((item, index) => (
                    <AmbiguousOption
                        onClick={this.onVariantClick}
                        value={item}
                        group={group}
                        selectedKey={searchForm[group].key}
                        key={index}
                    />
                ))}
            </ul>
        );
    }

    render() {
        const {searchForm} = this.props;
        const {ambiguous} = searchForm;

        const fromIsDefined = !ambiguous.from;
        const toIsDefined = !ambiguous.to;

        const columns = [];
        const titleParam = (fromIsDefined || toIsDefined) && {
            point: keyset(`${toIsDefined ? 'departure' : 'arrival'}-point`),
        };

        if (!fromIsDefined) {
            columns.push('from');
        }

        if (!toIsDefined) {
            columns.push('to');
        }

        return (
            <div className={b({isMobile})}>
                {(!fromIsDefined || !toIsDefined) && (
                    <div className={b('content')}>
                        <h1 className={b('title')}>{keyset('pre-title')}</h1>

                        <span className={b('pre-title')}>
                            {keyset(
                                !fromIsDefined && !toIsDefined
                                    ? 'full-title'
                                    : 'single-title',
                                titleParam,
                            )}
                        </span>

                        <div className={b('pointsContainer')}>
                            {columns.map(id => (
                                <div className={b('pointColumn')} key={id}>
                                    {!fromIsDefined && !toIsDefined && (
                                        <h3 className={b('pointTitle')}>
                                            {keyset(`title-${id}`)}
                                        </h3>
                                    )}

                                    {this.listCreator(id)}
                                </div>
                            ))}
                        </div>
                    </div>
                )}
            </div>
        );
    }
}

export default connect()(AmbiguousPage);
