import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import IconGlyph from '../../interfaces/components/IconGlyph';

import Icon from '../Icon/Icon';

const b = B('Arrow');

interface IArrow {
    className?: string;
    direction?: 'down' | 'left' | 'right' | 'up'; // down по умолчанию
    size?: 'm' | 's' | 'l'; // Трэвэльные размеры. Если не указать, то будет 9x5
}

export default memo(Arrow);

function Arrow({className, direction, size}: IArrow): ReactElement {
    return (
        <Icon
            className={b({direction, size}, className)}
            glyph={IconGlyph.arrowDown}
        />
    );
}
