import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import IconGlyph from '../../interfaces/components/IconGlyph';

import getInfoUrl from '../../lib/url/getInfoUrl';
import useSelector from '../useSelector';

import Link from '../Link';
import Icon from '../Icon/Icon';

import keyset from '../../i18n/common';

const b = B('Article');

const isMobile = process.env.PLATFORM === 'mobile';

interface IArticle {
    description: string;
    title: string;
    slug: string;

    className?: string;
    withSeparator?: boolean;
}

export default memo(Article);

function Article({
    description,
    title,
    slug,

    className,
    withSeparator,
}: IArticle): ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    return (
        <article className={b({isMobile, withSeparator}, className)}>
            <div className={b('title')}>{title}</div>

            <div className={b('description')}>{description}</div>

            <Link
                className={b('details')}
                href={getInfoUrl(slug, tld, language)}
            >
                <span className={b('detailsText')}>{keyset('details')}</span>

                <div className={b('arrowContainer')}>
                    <Icon className={b('arrow')} glyph={IconGlyph.arrowDown} />
                </div>
            </Link>
        </article>
    );
}
