import {React, PureComponent, B, mix, PropTypes} from '../base';

import Spinner from '../Spinner/Spinner';

export const b = B('BasicMap');

let promiseScriptLoading = null;

// Абстрактный класс для карт, для использования нужно переопределить метод renderMap
export default class BasicMap extends PureComponent {
    mapObject = {};
    className = '';

    static propTypes = {
        mapData: PropTypes.object.isRequired,
        id: PropTypes.string.isRequired,
    };

    componentDidMount() {
        this.loadAndRender();
    }

    loadAndRender() {
        promiseScriptLoading = (
            promiseScriptLoading ||
            new Promise(resolve => {
                (function (document) {
                    const target = document.getElementsByTagName('script')[0];
                    const script = document.createElement('script');

                    script.type = 'text/javascript';
                    script.src = 'https://api-maps.yandex.ru/2.1/?lang=ru_RU';
                    script.async = true;
                    script.onload = resolve;
                    target.parentNode.insertBefore(script, target);
                })(window.document);
            })
        ).then(this.renderMap);
    }

    renderMap = () => {
        throw new Error('Метод renderMap не определен');
    };

    render() {
        const {id} = this.props;

        return (
            <div className={mix(b(), this.className)} id={id}>
                <Spinner className={b('spinner')} size="large" />
            </div>
        );
    }
}
