import {React, PureComponent, B, PropTypes} from '../base';

import {STATION_PAGE_NAME} from '../../routes/station';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoal} from '../../lib/yaMetrika';

import Link from '../Link';
import Icon from '../Icon/Icon';

const b = B('Breadcrumbs');

export default class Breadcrumbs extends PureComponent {
    static propTypes = {
        elements: PropTypes.arrayOf(
            PropTypes.shape({
                name: PropTypes.string.isRequired,
                url: PropTypes.string,
                title: PropTypes.string,
            }),
        ).isRequired,

        layout: PropTypes.string,
        pageType: PropTypes.string,
    };

    onClick = () => {
        const {pageType} = this.props;

        reachGoal('breadcrumbs_click');

        if (pageType === STATION_PAGE_NAME) {
            reachGoal('station_breadcrumbs_click');
        }
    };

    render() {
        const {elements, layout, pageType} = this.props;

        if (!elements.length) {
            return null;
        }

        return (
            <div className={b({layout, pageType})}>
                <ol className={b('list')}>
                    {elements.map((item, index) => {
                        const useLink = index !== elements.length - 1;

                        return (
                            <li className={b('item')} key={index}>
                                {useLink ? (
                                    <Link
                                        className={b('link', {
                                            notStationPage:
                                                pageType !== STATION_PAGE_NAME,
                                        })}
                                        href={item.url}
                                        title={item.title}
                                        onClick={this.onClick}
                                        data-nosnippet={
                                            item.dataNoSnippet
                                                ? true
                                                : undefined
                                        }
                                    >
                                        {item.name}
                                    </Link>
                                ) : (
                                    <span
                                        data-nosnippet={
                                            item.dataNoSnippet
                                                ? true
                                                : undefined
                                        }
                                    >
                                        {item.name}
                                    </span>
                                )}
                                {useLink && (
                                    <Icon
                                        className={b('arrow')}
                                        glyph={IconGlyph.arrowDown}
                                    />
                                )}
                            </li>
                        );
                    })}
                </ol>
            </div>
        );
    }
}
