import {React, PureComponent, B, PropTypes} from '../base';

import {STATION_PAGE_NAME} from '../../routes/station';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoal} from '../../lib/yaMetrika';

import Link from '../Link';
import Icon from '../Icon/Icon';

const b = B('Breadcrumbs');

export default class Breadcrumbs extends PureComponent {
    static propTypes = {
        elements: PropTypes.arrayOf(
            PropTypes.shape({
                name: PropTypes.string.isRequired,
                url: PropTypes.string,
                title: PropTypes.string,
            }),
        ).isRequired,

        layout: PropTypes.string,
        pageType: PropTypes.string,
    };

    state = {
        itemsCollapsed: true,
    };

    onClick = () => {
        const {pageType} = this.props;

        reachGoal('breadcrumbs_click');

        if (pageType === STATION_PAGE_NAME) {
            reachGoal('station_breadcrumbs_click');
        }
    };

    onBadgeClick = () => {
        this.setState({
            itemsCollapsed: false,
        });
    };

    render() {
        const {elements, layout, pageType} = this.props;

        if (!elements.length) {
            return null;
        }

        return (
            <div className={b({layout, pageType})}>
                <ol className={b('list')}>
                    {elements.map((item, index) => {
                        const first = index === 0;
                        const last = index === elements.length - 1;
                        const useLink = !last;
                        const hidden =
                            !first && !last && this.state.itemsCollapsed;

                        return (
                            <li
                                className={b('item', {first, last, hidden})}
                                key={index}
                            >
                                {useLink ? (
                                    <Link
                                        className={b('link')}
                                        href={item.url}
                                        title={item.title}
                                        onClick={this.onClick}
                                        data-nosnippet={
                                            item.dataNoSnippet
                                                ? true
                                                : undefined
                                        }
                                    >
                                        {item.name}
                                    </Link>
                                ) : (
                                    <span
                                        data-nosnippet={
                                            item.dataNoSnippet
                                                ? true
                                                : undefined
                                        }
                                    >
                                        {item.name}
                                    </span>
                                )}
                                {useLink && (
                                    <Icon
                                        className={b('arrow')}
                                        glyph={IconGlyph.arrowDown}
                                    />
                                )}
                            </li>
                        );
                    })}

                    {elements.length > 2 && this.state.itemsCollapsed && (
                        <li className={b('item', {showButton: true})}>
                            <Icon
                                className={b('more')}
                                glyph={IconGlyph.more}
                                onClick={this.onBadgeClick}
                            />

                            <Icon
                                className={b('arrow')}
                                glyph={IconGlyph.arrowDown}
                            />
                        </li>
                    )}
                </ol>
            </div>
        );
    }
}
