import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import KeyCode from '../../interfaces/KeyCode';

import once from '../../lib/once';

const b = B('Button');

/**
 * @deprecated use Button2 instead
 */
export default class Button extends PureComponent {
    state = {
        pressed: false,
    };

    onMouseDown = e => {
        this.setState({pressed: true});
        once(document, 'mouseup', this.onDocumentMouseUp);

        if (this.props.onMouseDown) {
            this.props.onMouseDown(e);
        }
    };

    onDocumentMouseUp = () => {
        this.setState({pressed: false});
    };

    onKeyDown = e => {
        if (e.keyCode === KeyCode.space || e.keyCode === KeyCode.enter) {
            this.setState({pressed: true});
        }

        if (this.props.onKeyDown) {
            this.props.onKeyDown(e);
        }
    };

    onKeyUp = e => {
        this.setState({pressed: false});

        if (this.props.onKeyUp) {
            this.props.onKeyUp(e);
        }
    };

    render() {
        const {
            className,

            type,
            active,
            children,
            leftIcon,
            rightIcon,
            refCallback,
            width,
            ...props
        } = this.props;

        if (refCallback) {
            props.ref = refCallback;
        }

        return (
            <button
                className={b(
                    {
                        ...this.state,
                        active,
                    },
                    className,
                )}
                {...props}
                type={type}
                onMouseDown={this.onMouseDown}
                onKeyDown={this.onKeyDown}
                onKeyUp={this.onKeyUp}
                style={{width}}
            >
                <span
                    className={b('content', {
                        withIcons: Boolean(leftIcon || rightIcon),
                    })}
                >
                    {leftIcon && <span className={b('icon')}>{leftIcon}</span>}

                    {children && <span className={b('title')}>{children}</span>}

                    {rightIcon && (
                        <span className={b('icon')}>{rightIcon}</span>
                    )}
                </span>
            </button>
        );
    }
}

Button.defaultProps = {
    type: 'button',
};
