import React, {PureComponent, SyntheticEvent} from 'react';
import B from 'bem-cn-lite';

import Button from '../Button/Button';

const b = B('ButtonCheckbox');

interface IButtonCheckboxProps {
    value: boolean;

    onClick?(e: SyntheticEvent): void;
    active?: boolean;
    className?: string;
    leftIcon?: React.ReactElement;
    type?: 'mobileFilterButton';
    width?: string;
}

export default class ButtonCheckbox extends PureComponent<
    IButtonCheckboxProps,
    {}
> {
    onButtonClick = (e: SyntheticEvent): void => {
        const {active = true, onClick} = this.props;

        if (active && onClick) {
            onClick(e);
        }
    };

    render(): React.ReactElement {
        const {
            className,
            value,
            leftIcon,
            type,
            active = true,
            width,
        } = this.props;

        return (
            <div
                className={b(
                    {checked: Boolean(value), inactive: !active},
                    className,
                )}
                style={{width}}
            >
                <Button
                    className={b('button', {type})}
                    onClick={this.onButtonClick}
                    leftIcon={leftIcon}
                    width={width}
                >
                    <input type="checkbox" value={`${value}`} />

                    <span className={b('contentWrapper')}>
                        {this.props.children}
                    </span>
                </Button>
            </div>
        );
    }
}
