import React, {MouseEventHandler} from 'react';
import B from 'bem-cn-lite';

import {IWithClassName} from '../../interfaces/components/IWithClassName';

interface IButtonLinkProps extends IWithClassName {
    onClick: MouseEventHandler<HTMLButtonElement>;

    theme?: 'link' | 'textSecondary';
}

const b = B('ButtonLink');

const ButtonLink: React.FC<IButtonLinkProps> = ({
    onClick,
    children,

    className,
    theme = 'link',
}) => {
    return (
        <button className={b({theme}, className)} onClick={onClick}>
            {children}
        </button>
    );
};

export default ButtonLink;
