import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

const b = B('ButtonSkeleton');

export interface IButtonSkeletonProps {
    sizeMod?: 'm' | 'l' | 'filterButton';
    borderRadius?: 'none' | 'left' | 'right';
    withAnimation?: boolean;
    className?: string;
}

export default memo(ButtonSkeleton);

function ButtonSkeleton({
    sizeMod = 'l',
    borderRadius,
    withAnimation,
    className,
}: IButtonSkeletonProps): ReactElement {
    return (
        <div
            className={b(
                {size: sizeMod, borderRadius, withAnimation},
                className,
            )}
        />
    );
}
