import {Component} from '../base';
import {Moment} from 'moment';

import {ROBOT} from '../../lib/date/formats';

import IWhen from '../../interfaces/state/IWhen';
import IRange from '../../interfaces/date/IRange';
import IMergedMaskDaysOfWalking from '../../interfaces/maskDaysOfWalking/IMergedMaskDaysOfWalking';

interface IIsToday {
    day: Moment;
    today: Moment;
}

interface IIsSelected {
    day: Moment;
    value: IWhen;
}

interface IIsInactive {
    day: Moment;
    range: IRange;
}

interface IIsOutOfMask {
    day: Moment;
    mask: IMergedMaskDaysOfWalking;
}

export default class CalendarDayBase<P, S> extends Component<P, S> {
    isToday({day, today}: IIsToday): boolean {
        return day.isSame(today, 'day');
    }

    isSelected({day, value}: IIsSelected): boolean {
        return day.format(ROBOT) === value.date;
    }

    isInactive({day, range: {start, end}}: IIsInactive): boolean {
        return day.isBefore(start) || day.isAfter(end);
    }

    isOutOfMask({mask, day}: IIsOutOfMask): boolean {
        if (!mask) {
            return false;
        }

        return !mask[day.year()]?.[day.month() + 1]?.[day.date() - 1];
    }
}
