import {React, B, PropTypes} from '../base';

import {ROBOT} from '../../lib/date/formats';
import {isWeekend} from '../../lib/date/utils';

import CalendarDayBase from './CalendarDayBase';

const b = B('CalendarDay');
const r = B('RedesignedCalendarDay');

export default class CalendarDay extends CalendarDayBase {
    static propTypes = {
        day: PropTypes.moment.isRequired,
        today: PropTypes.moment.isRequired,
        range: PropTypes.momentRange.isRequired,
        value: PropTypes.datePickerValue.isRequired,
        isRedesigned: PropTypes.bool,
        onClick: PropTypes.func.isRequired,
        onMouseOut: PropTypes.func.isRequired,
        onMouseOver: PropTypes.func.isRequired,
    };

    shouldComponentUpdate(nextProps) {
        return (
            this.isToday(this.props) !== this.isToday(nextProps) ||
            this.isSelected(this.props) !== this.isSelected(nextProps) ||
            this.isInactive(this.props) !== this.isInactive(nextProps) ||
            this.isOutOfMask(this.props) !== this.isOutOfMask(nextProps)
        );
    }

    render() {
        const {props} = this;
        const {day, onClick, onMouseOut, onMouseOver, isRedesigned} = props;

        const date = day.date();
        const weekend = isWeekend(day.weekday());
        const cx = isRedesigned ? r : b;

        if (this.isInactive(props)) {
            return (
                <span className={cx({inactive: true, weekend})}>{date}</span>
            );
        }

        return (
            <span
                className={cx({
                    weekend,
                    today: this.isToday(props),
                    selected: this.isSelected(props),
                    outOfMask: this.isOutOfMask(props),
                })}
                data-date={day.format(ROBOT)}
                onClick={onClick}
                onMouseOut={onMouseOut}
                onMouseOver={onMouseOver}
            >
                {date}
            </span>
        );
    }
}
