import React, {useContext} from 'react';
import B from 'bem-cn-lite';

import {ROBOT} from '../../lib/date/formats';

import {isWeekend} from '../../lib/date/utils';
import getCrowdTestingUrl from '../../lib/url/getCrowdTestingUrl';

import StaticContext from '../StaicContext/StaticContext';

const b = B('CalendarDayLink');

export default function CalendarDayLink({
    day,
    today,
    dateStart = null,
    type = null,
    className = '',
    inactive = false,
    colorless = false,
    selected = false,
    ...props
}) {
    className = b(
        {
            inactive,
            today: today && today.isSame(day, 'day'),
            weekend: isWeekend(day.weekday()),
            type,
            colorless,
            selected,
            startDate: dateStart && dateStart.isSame(day, 'day'),
        },
        className,
    );

    const {isCrowdTesting} = useContext(StaticContext);

    if (isCrowdTesting && props.href) {
        props.href = getCrowdTestingUrl(props.href);
    }

    return (
        <a {...props} className={className} data-date={day.format(ROBOT)}>
            {day.date()}
        </a>
    );
}
