import {React, B, mix} from '../base';

import {ROBOT} from '../../lib/date/formats';

import {isWeekend} from '../../lib/date/utils';
import getCrowdTestingUrl from '../../lib/url/getCrowdTestingUrl';

import StaticContext from '../StaicContext/StaticContext';

import keyset from '../../i18n/search-hints';

const b = B('CalendarDayLink');

export default function CalendarDayLink({
    day,
    today,
    className = '',
    inactive = false,
    colorless = false,
    ...props
}) {
    today = today && today.isSame(day, 'day');
    className = mix(
        b({
            inactive,
            today,
            colorless,
            weekend: isWeekend(day.weekday()),
        }),
        className,
    );

    const {isCrowdTesting} = React.useContext(StaticContext);

    if (isCrowdTesting && props.href) {
        props.href = getCrowdTestingUrl(props.href);
    }

    return (
        <a {...props} className={className} data-date={day.format(ROBOT)}>
            {day.date()}
            {today && (
                <span className={b('todayTitle')}>{keyset('today')}</span>
            )}
        </a>
    );
}
