import React from 'react';
import B from 'bem-cn-lite';

import {SPECIAL_VALUES, MAIN_SPECIAL_KEYS} from '../../lib/date/values';

import {ICalendarToolbarProps} from './types';

const b = B('CalendarToolbar');

const CalendarToolbar: React.FC<ICalendarToolbarProps> = ({
    value,
    language,
    onClick,

    onMouseOut,
    onMouseOver,
    className,
    isRedesigned,
}) => (
    <ul className={b({redesigned: isRedesigned}, className)}>
        {MAIN_SPECIAL_KEYS.map(special => (
            <li
                className={b('special', {selected: special === value.special})}
                key={special}
                data-special={special}
                onClick={onClick}
                onMouseOut={onMouseOut}
                onMouseOver={onMouseOver}
            >
                {SPECIAL_VALUES[language][special]}
            </li>
        ))}
    </ul>
);

export default CalendarToolbar;
