import React from 'react';
import B from 'bem-cn-lite';

import {SPECIAL_VALUES, MAIN_SPECIAL_KEYS} from '../../lib/date/values';

import {ICalendarToolbarProps} from './types';

const b = B('CalendarToolbar');

const CalendarToolbar: React.FC<ICalendarToolbarProps> = ({
    value,
    onClick,
    language,

    className,
    isRedesigned,
}) => (
    <div className={b({redesigned: isRedesigned}, className)}>
        {MAIN_SPECIAL_KEYS.map(special => (
            <li
                className={b('special', {selected: special === value.special})}
                key={special}
                data-special={special}
                onClick={onClick}
            >
                {SPECIAL_VALUES[language][special]}
            </li>
        ))}
    </div>
);

export default CalendarToolbar;
