import React, {Component, MouseEventHandler} from 'react';
import B from 'bem-cn-lite';

import {WEEKDAY_NAMES_SHORT} from '../../lib/date/values';

import Lang from '../../interfaces/Lang';
import IWhen from '../../interfaces/state/IWhen';

import {isWeekend} from '../../lib/date/utils';

export interface ICalendarWeekdayProps {
    language: Lang;
    value: IWhen;
    weekday: number;
    onClick: MouseEventHandler;
    onMouseOut: MouseEventHandler;
    onMouseOver: MouseEventHandler;

    className?: string;
    isRedesigned?: boolean;
}

const b = B('CalendarWeekday');
const r = B('RedesignedCalendarWeekday');

function isSelected({weekday, value}: ICalendarWeekdayProps): boolean {
    return weekday === value.weekday;
}

export default class CalendarWeekday extends Component<ICalendarWeekdayProps> {
    shouldComponentUpdate(nextProps): boolean {
        return isSelected(this.props) !== isSelected(nextProps);
    }

    render(): React.ReactNode {
        const {
            weekday,
            language,
            onClick,
            onMouseOut,
            onMouseOver,
            isRedesigned,
        } = this.props;

        const className = (isRedesigned ? r : b)({
            weekend: isWeekend(weekday),
            selected: isSelected(this.props),
        });

        return (
            <li
                className={className}
                data-weekday={weekday}
                onClick={onClick}
                onMouseOut={onMouseOut}
                onMouseOver={onMouseOver}
            >
                {WEEKDAY_NAMES_SHORT[language][weekday]}
            </li>
        );
    }
}
