import React, {memo} from 'react';
import B from 'bem-cn-lite';

import SegmentCancelType from '../../interfaces/SegmentCancelType';
import ISegmentThreadBase from '../../interfaces/segment/ISegmentThreadBase';

import keyset from '../../i18n/badges';

const b = B('CanceledSegmentBadge');

interface ICanceledSegmentBadgeParams {
    cancelType: SegmentCancelType;

    cancelledSegments?: ISegmentThreadBase['cancelledSegments'];
}

export default memo(CanceledSegmentBadge);

function CanceledSegmentBadge({
    cancelType,

    cancelledSegments,
}: ICanceledSegmentBadgeParams): React.ReactElement {
    const badges =
        cancelType === SegmentCancelType.full ? (
            <div className={b('badge')}>
                {`${keyset('cancel')} ${keyset('fullCancel')}`}
            </div>
        ) : cancelledSegments && cancelledSegments.length ? (
            <>
                <div className={b('badge')}>{keyset('cancel')}</div>
                <div className={b('badge')}>
                    {keyset('canceledSegments', {
                        fromTitleGenitive:
                            cancelledSegments[0].fromTitleGenitive,
                        toTitleGenitive: cancelledSegments[0].toTitleGenitive,
                    })}
                </div>
            </>
        ) : null;

    return (
        <div className={b()}>
            <div className={b('container')}>{badges}</div>
        </div>
    );
}
