import React, {memo} from 'react';
import B from 'bem-cn-lite';

import SegmentCancelType from '../../interfaces/SegmentCancelType';
import ISegmentThreadBase from '../../interfaces/segment/ISegmentThreadBase';

import keyset from '../../i18n/badges';

const b = B('CanceledSegmentBadge');

function getCancelPathText(cancelType, cancelledSegments): string | null {
    if (cancelType === SegmentCancelType.full) {
        return keyset('fullCancel');
    }

    if (cancelledSegments && cancelledSegments.length) {
        const {fromTitleGenitive, toTitleGenitive} = cancelledSegments[0];

        return keyset('canceledSegments', {fromTitleGenitive, toTitleGenitive});
    }

    return null;
}

interface ICanceledSegmentBadgeParams {
    cancelType: SegmentCancelType;

    cancelledSegments?: ISegmentThreadBase['cancelledSegments'];
    className?: string;
}

export default memo(CanceledSegmentBadge);

function CanceledSegmentBadge({
    cancelType,

    cancelledSegments,
    className,
}: ICanceledSegmentBadgeParams): React.ReactElement | null {
    const cancelPathText = getCancelPathText(cancelType, cancelledSegments);

    return cancelPathText ? (
        <div className={b()}>
            <div className={b('badge', {color: 'red'}, className)}>
                {keyset('cancel')}
            </div>
            <div className={b('badge', {color: 'paleRed'}, className)}>
                {cancelPathText}
            </div>
        </div>
    ) : null;
}
