import {React, PureComponent, PropTypes, B, mix} from '../base';

import IconGlyph from '../../interfaces/components/IconGlyph';

import noop from '../../lib/noop';

import Icon from '../Icon/Icon';

const b = B('Checkbox');

export default class Checkbox extends PureComponent {
    static propTypes = {
        className: PropTypes.string,
        text: PropTypes.node.isRequired,
        disabled: PropTypes.bool,
        onMouseDown: PropTypes.func,
    };

    static defaultProps = {
        onMouseDown: noop,
        disabled: false,
    };

    state = {
        pressed: false,
    };

    onMouseDown = e => {
        this.press();
        this.props.onMouseDown(e);
    };

    onDocumentMouseUp = () => {
        this.release();
    };

    press() {
        this.setState({pressed: true});
        document.addEventListener('mouseup', this.onDocumentMouseUp);
    }

    release() {
        this.setState({pressed: false});
        document.removeEventListener('mouseup', this.onDocumentMouseUp);
    }

    render() {
        const {className, text, disabled, ...rest} = this.props;
        const {pressed} = this.state;

        return (
            <label className={mix(b({pressed, disabled}), className)}>
                <input
                    type="checkbox"
                    {...rest}
                    disabled={disabled}
                    className={b('input')}
                    onMouseDown={this.onMouseDown}
                />

                <span className={b('fakeInput')}>
                    <Icon className={b('tick')} glyph={IconGlyph.tick} />
                </span>

                <span className={b('text')}>{text}</span>
            </label>
        );
    }
}
