import {React, PureComponent, B} from '../base';

import {momentTimezone as moment} from '../../../reexports';

import {getNow} from '../../lib/date/utils';
import {TIME} from '../../lib/date/formats';

const b = B('Clock');
const MINUTE = 60000;

export default class Clock extends PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            now: getNow(),
        };
    }

    componentDidMount() {
        this.upDateTime();
    }

    componentWillUnmount() {
        clearTimeout(this._timeoutId);
    }

    upDateTime() {
        const now = getNow();

        this.setState({now: Math.round(now / MINUTE) * MINUTE});
        this._timeoutId = setTimeout(
            () => this.upDateTime(),
            MINUTE - (now % MINUTE),
        );
    }

    render() {
        const {userTimezone} = this.props;
        const {now} = this.state;

        const momentTime = moment.tz(now, userTimezone).format(TIME);
        const [hours, minutes] = momentTime.split(':');

        return (
            <span className={b()}>
                {hours}
                <span className={b('dots')}>:</span>
                {minutes}
            </span>
        );
    }
}
