import React, {memo} from 'react';
import B from 'bem-cn-lite';

const b = B('Collapse');

interface ICollapseParams {
    opened: boolean;
    buttonElement: React.ReactElement | React.ReactElement[] | string;
    onClick: () => void;
    contentElement: React.ReactElement | React.ReactElement[] | string;
}

export default memo(Collapse);

function Collapse({
    opened,
    buttonElement,
    onClick,
    contentElement,
}: ICollapseParams): React.ReactElement {
    return (
        <div className={b({opened})}>
            <div className={b('button')} onClick={onClick}>
                {buttonElement}
            </div>

            <div className={b('content')}>{contentElement}</div>
        </div>
    );
}
