import {React, mix} from '../base';

import Icon from '../Icon/Icon';
import IconGlyph from '../../interfaces/components/IconGlyph';

const b = 'CountryFlag';

export default function CountryFlag({className, countryCode}) {
    const glyph =
        countryCode === 'ru'
            ? IconGlyph.countryFlagRu
            : countryCode === 'ua'
            ? IconGlyph.countryFlagUa
            : undefined;

    return glyph && <Icon className={mix(b, className)} glyph={glyph} />;
}
