import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import {
    getCurrencySymbol,
    getCurrencyShortForm,
} from '../../lib/format/formatCurrency';

import {setUserPreferredCurrency} from '../../actions/currencies';

import Select from '../basic/Select/Select';

const b = B('CurrencySelect');

export default class CurrencySelect extends PureComponent {
    onChange = option => {
        this.props.dispatch(
            setUserPreferredCurrency(option.value, this.props.trackFunction),
        );
    };

    formatTitle = selectedOption => getCurrencyShortForm(selectedOption.value);

    getOptions() {
        return this.props.availableCurrencies.map(({code, title}) => ({
            value: code,
            title: this.getOptionTitle({code, title}),
        }));
    }

    getOptionTitle({code, title}) {
        const symbol = getCurrencySymbol(code);

        return symbol ? `${symbol} ${title}` : title;
    }

    render() {
        const {preferredCurrency, className, popupPositions} = this.props;

        const selectOptions = this.getOptions();
        const selectValue = selectOptions.find(
            ({value}) => value === preferredCurrency,
        );

        return (
            <Select
                className={b(undefined, className)}
                value={selectValue}
                defaultValue={selectValue}
                options={selectOptions}
                onChange={this.onChange}
                formatTitle={this.formatTitle}
                popupPositions={popupPositions}
            />
        );
    }
}
