import {React, PureComponent, B, mix} from '../base';

import {SPECIAL_VALUES, MAIN_SPECIAL_KEYS} from '../../lib/date/values';

import {buildSpecial} from '../../lib/date/build';
import {getParseParams} from '../../lib/date/utils';
import {setWhen} from '../../actions/searchForm';
import {reachGoal} from '../../lib/yaMetrika';

import Button from '../Button/Button';

const b = B('DateHints');

export default class DateHints extends PureComponent {
    onClick = e => {
        const props = this.props;
        const special = e.currentTarget.dataset.special;
        const value = buildSpecial(special, getParseParams(props));

        this.props.dispatch(setWhen(value));
        reachGoal('search_hints_date_hint_click');
    };

    render() {
        const {className, language} = this.props;

        return (
            <span className={mix(b(), className)}>
                {MAIN_SPECIAL_KEYS.map(special => (
                    <Button
                        key={special}
                        className={b('link')}
                        data-special={special}
                        onClick={this.onClick}
                    >
                        {SPECIAL_VALUES[language][special]}
                    </Button>
                ))}
            </span>
        );
    }
}
