import React from 'react';
import B from 'bem-cn-lite';

import {momentTimezone as moment} from '../../../reexports';

import {HUMAN} from '../../lib/date/formats';

const b = B('DatesSeparator');

interface IDatesSeparatorProps {
    date: string;
    endOfDay: boolean;
    timezone: string;
}

const DatesSeparator: React.FC<IDatesSeparatorProps> = ({
    date,
    endOfDay,
    timezone,
}) => {
    const momentDate = endOfDay
        ? moment.tz(date, timezone).endOf('day')
        : moment.tz(date, timezone).startOf('day');

    return <div className={b()}>{momentDate.format(HUMAN)}</div>;
};

export default React.memo(DatesSeparator);
