import {React, Component, B} from '../base';

import {momentTimezone as moment} from '../../../reexports';

import {TIME, HUMAN_SHORT} from '../../lib/date/formats';

const b = B('DatesSeparator');

export default class DatesSeparator extends Component {
    shouldComponentUpdate(nextProps) {
        return nextProps.date !== this.props.date;
    }

    render() {
        const {date, endOfDay, timezone} = this.props;
        const momentDate = endOfDay
            ? moment.tz(date, timezone).endOf('day')
            : moment.tz(date, timezone).startOf('day');

        return (
            <div className={b()}>
                <span className={b('date')}>
                    {`${momentDate.format(TIME)}, ${momentDate.format(
                        HUMAN_SHORT,
                    )}`}
                </span>
            </div>
        );
    }
}
