import {React} from '../base';
import BaseDisclaimer from './BaseDisclaimer';

import insertMarkupIntoKey from '../../i18n/_utils/insertMarkupIntoKey';

import Link from '../Link';
import DynamicPricing from '../basic/bages/SegmentDynamicPricing';

import keyset from '../../i18n/disclaimers';

export default class DynamicPricingDisclaimer extends BaseDisclaimer {
    getContent() {
        return insertMarkupIntoKey(keyset, 'dynamic-pricing-template', {
            badge: <DynamicPricing key="dynamicPricing" />,
            link: (
                <Link
                    key="link"
                    rel="nofollow"
                    target="_blank"
                    href="http://pass.rzd.ru/static/public/ru?STRUCTURE_ID=5227"
                >
                    {keyset('dynamic-pricing-link')}
                </Link>
            ),
        });
    }
}
