import {React} from '../base';
import BaseDisclaimer from './BaseDisclaimer';

import insertMarkupIntoKey from '../../i18n/_utils/insertMarkupIntoKey';

import Link from '../Link';
import ETicket from '../basic/bages/ETicket';

import keyset from '../../i18n/disclaimers';

export default class ETicketDisclaimer extends BaseDisclaimer {
    getContent() {
        return insertMarkupIntoKey(keyset, 'e-ticket-template', {
            badge: <ETicket key="eticket" />,
            link: (
                <Link
                    href="https://yandex.ru/support/rasp/train/e-registration.html"
                    target="_blank"
                    rel="nofollow"
                    key="link"
                >
                    {keyset('e-ticket-link')}
                </Link>
            ),
        });
    }
}
