import React from 'react';
import B from 'bem-cn-lite';
import {unitOfTime} from 'moment';
import {momentTimezone as moment} from '../../../reexports';

import {IWithClassName} from '../../interfaces/components/IWithClassName';
import IDurationRoundingOptions from '../../interfaces/date/IDurationRoundingOptions';

import {humanizeDuration} from '../../lib/date/formats';

const b = B('Duration');

interface IDurationProps extends IWithClassName {
    duration: number;

    defaultValue?: string;
    unit?: unitOfTime.DurationConstructor;
    options?: Partial<IDurationRoundingOptions>;
}

const Duration: React.FC<IDurationProps> = ({
    duration,
    unit,
    className,
    options,
    defaultValue = '',
}) => {
    return (
        <span className={b({}, className)}>
            {humanizeDuration(moment.duration(duration, unit), options) ||
                defaultValue}
        </span>
    );
};

export default Duration;
