import {React, B, ConstantComponent} from '../base';

import {reachGoal} from '../../lib/yaMetrika';

import httpErrorKeyset from '../../i18n/http-error';

const b = B('Error404Block');

export default class Error404Block extends ConstantComponent<{}, {}> {
    componentDidMount(): void {
        reachGoal('page_404_show');
    }

    render(): React.ReactElement {
        return (
            <div className={b()}>
                <h2 className={b('errorStatus')}>404</h2>

                <p
                    className={b('errorDescription')}
                    dangerouslySetInnerHTML={{
                        __html: httpErrorKeyset('text-404'),
                    }}
                />
            </div>
        );
    }
}
