import {React, ConstantComponent, B} from '../base';

import {reachGoal} from '../../lib/yaMetrika';

import Direct from '../Direct/Direct';

import httpErrorKeyset from '../../i18n/http-error';

const b = B('Error404Block');

export default class Error404Block extends ConstantComponent<null, null> {
    componentDidMount(): void {
        reachGoal('page_404_show');
    }

    render(): React.ReactElement {
        return (
            <div className={b()}>
                <div className={b('content')}>
                    <h2 className={b('errorStatus')}>404</h2>

                    <p
                        className={b('errorDescription')}
                        dangerouslySetInnerHTML={{
                            __html: httpErrorKeyset('text-404'),
                        }}
                    />
                </div>

                <Direct blockId="R-I-239082-53" />
            </div>
        );
    }
}
