import React from 'react';
import B from 'bem-cn-lite';
import Helmet from 'react-helmet';

import useSelector from '../useSelector';
import defaultMetaInformation from '../../lib/meta/metaPages/default';

import HeaderLogo from '../HeaderLogo/HeaderLogo';

import httpErrorKeyset from '../../i18n/http-error';

const b = B('Error500');

const isMobile = process.env.PLATFORM === 'mobile';

const Error500: React.FC = () => {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    return (
        <div className={b()}>
            <Helmet {...defaultMetaInformation({tld, language})} />

            <div className={b('logo')}>
                <HeaderLogo tld={tld} isMobile={isMobile} />
            </div>

            <h1 className={b('code')}>500</h1>
            <p className={b('description')}>{httpErrorKeyset('text-500')}</p>
        </div>
    );
};

export default Error500;
