import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import SearchErrorPageType from '../../../common/interfaces/components/searchErrorPage/SearchErrorPageType';
import Platform from '../../../common/interfaces/Platform';
import {ERROR_TYPES} from '../../../common/lib/errors/errorTypes';
import IStateSearchForm from '../../../common/interfaces/state/IStateSearchForm';
import IStateSearch from '../../../common/interfaces/state/search/IStateSearch';

import ErrorPageCommon from './ErrorPageCommon';
import AmbiguousPage from '../AmbiguousPage/AmbiguousPage';
import SearchErrorDesktop from '../SearchError/SearchError.desktop';
import SearchErrorMobile from '../SearchError/SearchError.mobile';

const b = B('ErrorPage');

const isMobile = process.env.PLATFORM === Platform.mobile;

interface IErrorPageProps {
    type: string;
    searchForm: IStateSearchForm;
    search: IStateSearch;
}

export default class ErrorPage extends PureComponent<IErrorPageProps> {
    getErrorPage(): React.ReactElement | null {
        const {type, searchForm, search} = this.props;

        switch (type) {
            case ERROR_TYPES.AMBIGUOUS:
                return <AmbiguousPage searchForm={searchForm} />;
            case ERROR_TYPES.SEARCH_FORM:
                if (searchForm.errors.length) {
                    return isMobile ? (
                        <SearchErrorMobile
                            context={search.context}
                            searchForm={searchForm}
                            type={SearchErrorPageType.reload}
                        />
                    ) : (
                        <SearchErrorDesktop
                            context={search.context}
                            searchForm={searchForm}
                            type={SearchErrorPageType.reload}
                        />
                    );
                }

                return null;

            default:
                return <ErrorPageCommon />;
        }
    }

    render(): React.ReactElement {
        return <div className={b()}>{this.getErrorPage()}</div>;
    }
}
