import {React, PureComponent, B} from '../base';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoal} from '../../lib/yaMetrika';
import tankerParse from '../../lib/tanker/tankerParse';

import Icon from '../Icon/Icon';

import keyset from '../../i18n/error-page-common';

const b = B('ErrorPageCommon');

export default class ErrorPageCommon extends PureComponent {
    componentDidMount() {
        reachGoal('error-page-common-show', {
            'error-page-common-show-url': window.location.href,
        });
    }

    render() {
        return (
            <div className={b()}>
                <div className={b('sadness')}>
                    <Icon className={b('image')} glyph={IconGlyph.face} />
                </div>

                <div className={b('title')}>{keyset('title')}</div>
                <div className={b('description')}>
                    {tankerParse(keyset('description'), {}, true)}
                </div>
            </div>
        );
    }
}
