import React, {memo, ReactElement, Fragment} from 'react';
import B from 'bem-cn-lite';

import stationKeyset from '../../i18n/station';

const b = B('ExceptString');

const reg = new RegExp(
    `(^|.+?)(?:(${stationKeyset('except')}:?)(.+?)(${stationKeyset(
        'next',
    )}|$)|$)`,
    'gi',
);

interface IExceptString {
    text: string;

    fontWeightForExcept?: 'normal' | 'bold';
    className?: string;
}

export default memo(ExceptString);

// Компонент для выделения в строке красным цветом "кроме ...."
function ExceptString({
    text,

    fontWeightForExcept,
    className,
}: IExceptString): ReactElement {
    reg.lastIndex = 0;
    const result: ReactElement[] = [];
    let match: RegExpExecArray | null;

    while ((match = reg.exec(text)) !== null) {
        result.push(
            <Fragment key={result.length}>
                {match[1]}

                {match[2] && (
                    <span className={b('except')}>
                        {stationKeyset('except')} {match[3]}
                    </span>
                )}

                {match[4]}
            </Fragment>,
        );
    }

    return (
        <span className={b({fontWeightForExcept}, className)}>{result}</span>
    );
}
