import {React, B} from '../base';

import ISegmentFacility from '../../interfaces/segment/ISegmentFacility';

const b = B('FacilityIcon');

interface IFacilityIcon extends ISegmentFacility {
    className?: string;
}

function FacilityIcon({
    code,
    icon,
    title,
    className,
}: IFacilityIcon): React.ReactElement {
    return <img className={b({code}, className)} src={icon} alt={title} />;
}

export default React.memo(FacilityIcon);
