import {React, PureComponent, B, mix} from '../base';

import noop from '../../lib/noop';
import filter from '../../lib/filters/aeroexpress';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import filterKeyset from '../../i18n/filter-aeroexpress';

const b = B('FilterAeroexpress');

export default class FilterAeroexpress extends PureComponent {
    onChange = (e, {value}) => {
        this.updateFilter(value);
    };

    updateFilter(value) {
        this.props.onChange({
            type: filter.type,
            value,
        });
    }

    getButtonText() {
        const {value} = this.props;

        if (value.length === 0) {
            return filterKeyset('title');
        }

        return value.map(val => filterKeyset(val)).join(', ');
    }

    getOptions() {
        const {options} = this.props;

        return options.map(option => ({
            value: option,
            text: filterKeyset(option),
        }));
    }

    render() {
        const {className, value, activeOptions} = this.props;

        return (
            <Dropdown
                className={mix(b(), className)}
                inactive={activeOptions.length === 0}
                buttonText={this.getButtonText()}
                highlighted={value.length > 0}
                onOpen={this.onOpen}
            >
                <CheckList
                    className={b('options')}
                    value={value}
                    options={this.getOptions()}
                    activeOptions={activeOptions}
                    onChange={this.onChange}
                />
            </Dropdown>
        );
    }
}

FilterAeroexpress.defaultProps = {
    onChange: noop,
};
