import {React, PureComponent, B, mix} from '../base';

import noop from '../../lib/noop';
import filter from '../../lib/filters/carriers';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import filterKeyset from '../../i18n/filter-carriers';

const b = B('FilterCarriers');
const COLUMN_OPTIONS_MINIMUM = 8;

export default class FilterCarriers extends PureComponent {
    onChange = (e, {value}) => {
        this.props.onChange({
            type: filter.type,
            value,
        });
    };

    getButtonText() {
        const {value, options} = this.props;

        if (value.length === 0) {
            return filterKeyset('title');
        }

        if (value.length < 3) {
            return options
                .filter(option => value.includes(option.id))
                .map(option => option.title)
                .sort()
                .join(', ');
        }

        return filterKeyset('title-selected', {
            count: value.length,
        });
    }

    getOptions() {
        const {options} = this.props;
        const items = options
            .map(option => ({
                value: option.id,
                text: option.title,
            }))
            .sort((current, next) => current.text.localeCompare(next.text));

        return items;
    }

    getColumnsCount(optionsLength) {
        return optionsLength >= COLUMN_OPTIONS_MINIMUM ? 2 : 1;
    }

    render() {
        const {className, value, activeOptions, popupPositions} = this.props;

        const activeOptionsIds = activeOptions.map(option => option.id);
        const options = this.getOptions();
        const columnsCount = this.getColumnsCount(options.length);

        return (
            <Dropdown
                className={mix(b(), className)}
                inactive={activeOptions.length === 0}
                buttonText={this.getButtonText()}
                highlighted={value.length > 0}
                popupPositions={popupPositions}
                onOpen={this.onOpen}
            >
                <CheckList
                    className={b('options')}
                    value={value}
                    options={options}
                    activeOptions={activeOptionsIds}
                    onChange={this.onChange}
                    columnsCount={columnsCount}
                />
            </Dropdown>
        );
    }
}

FilterCarriers.defaultProps = {
    onChange: noop,
};
