import FilterBase from './FilterCarriers.base';

import filterKeyset from '../../i18n/filter-carriers';

export default class FilterCarriers extends FilterBase {
    getButtonText() {
        const {value, options} = this.props;

        if (value.length === 0) {
            return 'не важно';
        }

        if (value.length < 3) {
            return options
                .filter(option => value.includes(option.id))
                .map(option => option.title)
                .sort()
                .join(', ');
        }

        return filterKeyset('title-selected', {
            count: value.length,
        });
    }

    getColumnsCount() {
        return 1;
    }
}
