import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import Platform from '../../interfaces/Platform';

import noop from '../../lib/noop';
import filter from '../../lib/filters/express';

import ButtonCheckbox from '../ButtonCheckbox/ButtonCheckbox';

import keyset from '../../i18n/filter-express';

const b = B('FilterExpress');
const isMobile = process.env.PLATFORM === Platform.mobile;

export default class FilterExpress extends PureComponent {
    onClick = () => {
        this.props.onChange({
            type: filter.type,
            value: !this.props.value,
        });
    };

    render() {
        const {className, value, activeOptions} = this.props;

        return (
            <div className={b({isMobile}, className)}>
                <ButtonCheckbox
                    value={value}
                    onClick={this.onClick}
                    active={activeOptions.withExpress}
                    type={isMobile ? 'mobileFilterButton' : undefined}
                    width={isMobile ? '100%' : undefined}
                >
                    {keyset('title')}
                </ButtonCheckbox>
            </div>
        );
    }
}

FilterExpress.defaultProps = {
    onChange: noop,
};
