import React, {useCallback} from 'react';
import B from 'bem-cn-lite';

import useDispatch from '../useDispatch';
import {GONE_FILTER_TYPE} from '../../lib/filters/gone';
import scrollWindow from '../../../client/lib/scrollWindow';

import {updateFilterValue} from '../../actions/search/filters';

import keyset from '../../i18n/filter-gone';

const b = B('FilterGone');

interface IFilterGoneProps {
    className?: string;
    value?: boolean;
    activeOptions: {isGone: number; isNotGoneYet: number};
}

const FilterGone: React.FC<IFilterGoneProps> = ({
    value,
    activeOptions,
    className,
}) => {
    const dispatch = useDispatch();
    const handleClick = useCallback(() => {
        if (value === true) {
            scrollWindow(0);
        }

        dispatch(
            updateFilterValue({
                type: GONE_FILTER_TYPE,
                value: !value,
            }),
        );
    }, [value, dispatch]);

    return (
        <button className={b({}, className)} onClick={handleClick}>
            <span className={b('goneTitle')}>
                {keyset(value ? 'hide' : 'show')}
                <span className={b('goneCounter')}>
                    {' '}
                    {activeOptions.isGone}
                </span>
            </span>
        </button>
    );
};

export default FilterGone;
