import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import {GONE_FILTER_TYPE} from '../../lib/filters/gone';

import scrollWindow from '../../../client/lib/scrollWindow';

import {updateFilterValue} from '../../actions/search/filters';

import ButtonCheckbox from '../ButtonCheckbox/ButtonCheckbox';

import keyset from '../../i18n/filter-gone';

const b = B('FilterGone');

export default class FilterGone extends PureComponent {
    onClick = () => {
        const {value, dispatch} = this.props;

        if (value === true) {
            scrollWindow(0);
        }

        dispatch(
            updateFilterValue({
                type: GONE_FILTER_TYPE,
                value: !value,
            }),
        );
    };

    render() {
        const {value, activeOptions, availableWithActiveOptions, className} =
            this.props;

        return (
            <div className={b({}, className)}>
                <ButtonCheckbox
                    value={value}
                    onClick={this.onClick}
                    active={availableWithActiveOptions}
                >
                    <span className={b('goneTitle')}>
                        {keyset(value ? 'hide' : 'show')}
                        <span className={b('goneCounter')}>
                            {' '}
                            {activeOptions.isGone}
                        </span>
                    </span>
                </ButtonCheckbox>
            </div>
        );
    }
}
